<?php

namespace app\merchant\controller;

use app\common\model\Goods as GoodsModel;
use app\common\model\GoodsCard as CardModel;
use app\common\model\GoodsCategory as CategoryModel;
use app\common\model\ProxyCode as ProxyCodeModel;
use app\common\model\GoodsPond as GoodsPondModel;
use service\MerchantLogService;
use think\Controller;
use think\Db;
use think\Exception;
use think\Request;

class Goods extends Base
{
    // 商品列表
    public function index()
    {
        $this->setTitle('商品列表');
        ////////////////// 查询条件 //////////////////
        $query = [
            'cate_id' => input('cate_id/s', ''),
            'name' => input('name/s', ''),
            'is_proxy' =>0,
        ];
        $where = $this->genereate_where($query);
        $goodsList = GoodsModel::where($where)->order('sort desc,id desc')->paginate(30, false, [
            'query' => $query,
        ]);

        // 分页
        $page = $goodsList->render();
        $this->assign('page', $page);
        $this->assign('goodsList', $goodsList);

        // 商品分类
        $categorys = CategoryModel::where(['user_id' => $this->user->id])->order('sort desc,id desc')->select();
        $this->assign('categorys', $categorys);
        return $this->fetch();
    }

    // 改变状态
    public function changeStatus()
    {
        if (!$this->request->isPost()) {
            return;
        }
        $goods_id = input('id/d', 0);
        $goods = GoodsModel::get(['id' => $goods_id, 'user_id' => $this->user->id]);
        if($goods['code_id']!=0){
            $code=ProxyCodeModel::find($goods['code_id']);
            if($goods['is_proxy']==1&&GoodsModel::get(['id' => $code->goods_id])['status']==0){
                return J(1, '该商品的授权商品已下架');
            }
            if($goods['is_proxy']==1&&$code->delect_at>0){
                return J(1, '该商品的授权商品已下架');
            }
        }
        
        if (!$goods) {
            $this->error('不存在该商品！');
        }
        if ($goods->is_freeze == 1) {
            $this->result('', 1, '该商品已被冻结，如果要上架，请修改相关商品信息再上架', 'json');
        }
        $status = input('status/d', 0);
        $status = $status ? 1 : 0;
        $statusStr = $status == 1 ? '上架' : '下架';
        $goods->status = $status;
        $res = $goods->save();

        // 更新代理商品的上下架状态
        $codes=ProxyCodeModel::where(['goods_id'=>$goods_id,'delect_at'=>0])->column('id');
        $codes=implode(',',$codes);
        if(!empty($codes)){
            if($status==0){
                GoodsModel::where(['code_id'=>['in',$codes]])->update(['status'=>0]);
                MerchantLogService::write('修改代理商品状态', '将代理商品ID为' . $goods_id . '的商品' . $statusStr);
            }else if($status==1){
                GoodsModel::where(['code_id'=>['in',$codes]])->update(['status'=>1]);
                MerchantLogService::write('修改代理商品状态', '将代理商品ID为' .$goods_id . '的商品' . $statusStr);
            }
        }
        
       
        if ($res !== false) {
            MerchantLogService::write('修改商品状态', '将ID为' . $goods_id . '的商品' . $statusStr);
            return J(0, 'success');
        } else {
            return J(1, 'error');
        }
    }

    //添加授权价格
    public function addPorxyCode(){
        $data=input('post.');
        $proxy_code=$this->noRepeat();
        if(ProxyCodeModel::where(['goods_id'=>$data['id'],'delect_at'=>0])->where('price',$data['value'])->count()>0){
            return J(0, '价格已设置');
        }else{
           
            $proxycode=new ProxyCodeModel();
            $proxycode->create_at=time();
            $proxycode->code=$proxy_code;
            $proxycode->price=number_format($data['value'],2);
            $proxycode->goods_id=$data['id'];
            $proxycode->user_id=$this->user->id;
            $proxycode->save();
        }
        return J(1, '您的授权码为:'.$proxy_code);
    }
    //返回不重复的code值
    private function noRepeat(){
        $index=0;
        while(true){
            $index+=1;
            $code=substr('YFKDJ'.md5(uniqid()),0,12);
            if(empty(ProxyCodeModel::where('code',$code)->find())){
                return $code;
            }
            if($index>20){
                return J(0, '生成授权码失败');
            }
        }
    }
    //修改价格
    public function codeChangePrice(){
        $id = input('id/d', 0);
        $value = input('value/d', 0);
        $code=ProxyCodeModel::find($id);
        $oldprice=$code->price;
        if($oldprice==$value){
            return J(0,'价格未修改');
        }
         // 批量修改代理商品价格
         $allProxy=GoodsModel::where(['code_id' => $id])->select();
         $code->price=$value;
         $code->save();
         if(count($allProxy)!=0){
             
             $num=$value-$oldprice;
             foreach($allProxy as $k=>$v ){
                 GoodsModel::where('id',$v['id'])->update([
                     'price'=>$v['price']+$num,
                     'cost_price'=>$value
                 ]);
             }
            
         }
         return J(1,'价格修改成功');
    }
    //授权删除
    public function codeDelect(){
        $id = input('code_id/d', 0);
        $code=ProxyCodeModel::where(['id'=>$id,'delect_at'=>0])->find();
        
        Db::startTrans();
        try{
            if(!empty($code)){
                GoodsModel::where(['code_id'=>$code->id])->update(['status'=>0]);
                MerchantLogService::write('修改代理商品状态', '将授权码为' . $code->id . '的商品下架');
                $code->delect_at=time();
                $code->save();
            }
            Db::commit();
            return J(1,'删除成功');
        }catch (\Exception $e) {
            Db::rollback();
            return J(1, $e->getMessage());
        }
       
    }
    // 授权列表
    public function codelist(){
        $goods_id = input('id/d', 0);
        $codelist=ProxyCodeModel::where(['goods_id'=>$goods_id,'delect_at'=>['=',0]])->select();
        $goodspondCount=GoodsPondModel::where(['goods_id'=>$goods_id,'delect_at'=>['=',0]])->count();
        $this->assign(['list'=>$codelist,'user'=>$this->user,'goods_id'=>$goods_id,"goodspondCount"=>$goodspondCount]);
        return $this->fetch();
    }
   
    //放入商品池
    public function addpond(){
        $goods_id = input('id/d', 0);
        $code_id = input('code_id/d', 0);
        if(GoodsPondModel::where(['goods_id'=>$goods_id,'delect_at'=>0])->count()>0){
            return J(0, '改商品已加入商品池');
        }
        if(GoodsPondModel::where('auth_id',$code_id)->count()>0){
            $pond=GoodsPondModel::where(['auth_id'=>$code_id])->find();
            if($pond->delect_at>0){
                $pond->delect_at=0;
                $pond->save();
                return J(1, '加入商品池成功');
            }else{
              return J(0, '已放入商品池');
            }   
        }
        $goodsPond=new GoodsPondModel();
        $goodsPond->auth_id=$code_id;
        $goodsPond->user_id=$this->user->id;
        $goodsPond->goods_id=$goods_id;
        $goodsPond->create_at=time();
        $goodsPond->save();
        return J(1, '加入商品池成功');
    }
    //移除商品池
    public function removepond(){
        $goods_id = input('id/d', 0);
        $code_id = input('code_id/d', 0);
        $goodsPond=GoodsPondModel::where(['auth_id'=>$code_id,'delect_at'=>['=',0]])->find();
        if(empty($goodsPond)){
            return J(0, '不在商品池');
        }
        $goodsPond->delect_at=time();
        $goodsPond->save();
        return J(1, '移除成功');
    }
    //置顶操作
    public function movepond(){
      
        $id = input('id/d', 0);
        $goodsPond=GoodsPondModel::where(['id'=>$id,'delect_at'=>['=',0]])->find();
        if(empty($goodsPond)){
            return J(0, '不在商品池');
        }
        $goodsPond->sort=$goodsPond->sort==0?1:0;
        $goodsPond->save();
        return J(1, '位移成功');
    }
    
    // 代理商品
    public function proxy()
    {
        $this->setTitle('代理商品列表');
        ////////////////// 查询条件 //////////////////
        $query = [
            'cate_id' => input('cate_id/s', ''),
            'name' => input('name/s', ''),
            'is_proxy' => 1,
        ];
        $where = $this->genereate_where($query);

        $goodsList = GoodsModel::where($where)->order('sort desc,id desc')->paginate(30, false, [
            'query' => $query,
        ]);

        
        // 分页
        $page = $goodsList->render();
        $this->assign('page', $page);
        $this->assign('goodsList', $goodsList);
        // 商品分类
        $categorys = CategoryModel::where(['user_id' => $this->user->id])->order('sort desc,id desc')->select();
        $this->assign('categorys', $categorys);
        return $this->fetch();
    }


     // 代理商品添加
     public function proxyadd()
     {
         if (!$this->request->isPost()) {
             $this->setTitle('添加商品');
             // 商品分类
             $categorys = CategoryModel::where(['user_id' => $this->user->id, 'status' => 1])->order('sort desc,id desc')->select();
             $this->assign('categorys', $categorys);
             return $this->fetch('proxyedit');
         }
 
         if (input('price/f', 0) <= input('cost_price/f', 0)) {
             $this->error('商品价格不能低于等于进价');
         }
 
         $proxy_code=input('proxy_code/s', '');
         if(empty($proxy_code)){
             $this->error('授权码不能为空');
         }else{
             $ProxyCode=ProxyCodeModel::get(['code'=>$proxy_code,'delect_at'=>['=',0]]);
             if (!$ProxyCode) {
                 $this->error('不存在该授权码！');
             }
         }
         if(GoodsModel::get(['id'=>$ProxyCode->goods_id])->status==0){
            $this->error('改授权商品已下架，无法代理');
         }
         // 检查商品价格不能低于被代理商品
         if(input('price/f', 0)<=$ProxyCode->price){
             $this->error('商品价格不能低于或等于商品代理价格');
         }
 
         // 不能代理自己的商品
         if($this->user->id==$ProxyCode->user_id){
             $this->error('不能代理自己的商品');
         }
 
         if(GoodsModel::get(['user_id'=>$this->user->id,'code_id'=>$ProxyCode->id])){
             $this->error('该授权码已代理');
         }

 
         $data = [
             'user_id' => $this->user->id,
             'cate_id' => input('cate_id/d', 0),
             'theme' => input('theme/s', 'default'),
             'sort' => input('sort/d', 0),
             'name' => input('name/s', ''),
             'price' => input('price/f', 0),
             'cost_price' => input('cost_price/f', 0),
             'wholesale_discount' => input('wholesale_discount/d', 0),
             'wholesale_discount_list' => input('wholesale_discount_list/a', []),
             'limit_quantity' => input('limit_quantity/d', 1),
             'inventory_notify' => input('inventory_notify/d', 0),
             'inventory_notify_type' => input('inventory_notify_type/d', 1),
             'coupon_type' => input('coupon_type/d', 0),
             'sold_notify' => input('sold_notify/d', 0),
             'take_card_type' => input('take_card_type/d', 0),
             'visit_type' => input('visit_type/d', 0),
             'visit_password' => input('visit_password/s', ''),
             'contact_limit' => input('contact_limit/s', ''),
             'content' => input('content/s', ''),
             'remark' => input('remark/s', ''),
             'sms_payer' => input('sms_payer/d', 0),
             'status' => 1,
             'create_at' => $_SERVER['REQUEST_TIME'],
             'is_proxy' => 1,
             'code_id' => $ProxyCode->id,
             "parent_user_id"=>$ProxyCode->user_id
         ];
         // 字词检查
         $res = check_wordfilter($data['name']);
         if ($res !== true) {
             $this->error('商品名包含敏感词汇“' . $res . '”！');
         }
         $res = check_wordfilter($data['content']);
         if ($res !== true) {
             $this->error('商品说明包含敏感词汇“' . $res . '”！');
         }
         $res = check_wordfilter($data['remark']);
         if ($res !== true) {
             $this->error('使用说明包含敏感词汇“' . $res . '”！');
         }
         $category = CategoryModel::get(['id' => $data['cate_id'], 'user_id' => $this->user->id]);
         if (!$category) {
             $this->error('不存在该分类！');
         }
         //检查商品价格区间
         if (sysconf('goods_min_price') > 0 && $data['price'] < sysconf('goods_min_price')) {
             $this->error('商品价格不能少于' . sysconf('goods_min_price') . '元');
         }
 
         if (sysconf('goods_max_price') > 0 && sysconf('goods_max_price') < $data['price']) {
             $this->error('商品价格不能超过' . sysconf('goods_max_price') . '元');
         }
 
         
 
 
         $res = $this->validate($data, 'Goods');
         if ($res !== true) {
             $this->error($res);
         }
         $res = GoodsModel::create($data);
         if ($res !== false) {
             //创建成功，马上创建短链接
             GoodsModel::makeLink($data['user_id'], $res->id);
             MerchantLogService::write('添加代理商品成功', '添加商品成功，商品ID:' . $res->id . ',名称:' . $res->name . ',价格:' . $res->price . ',成本价:' . $res->cost_price);
             $this->redirect('/merchant/goods/proxy');
         } else {
             $this->error('添加失败！');
         }
     }
 
  //根据授权码获取价格
  public function codechange(){
    $proxy_code=input('code/s', '');
    if(empty($proxy_code)){
       return J(0,'授权码错误');
    }else{
        $ProxyCode=ProxyCodeModel::get(['code'=>$proxy_code,'delect_at'=>['=',0]]);
        $goods=GoodsModel::get(['id'=>$ProxyCode->goods_id]);
        if (!$ProxyCode) {
            return J(0,'授权码错误');
        }else{
            return J(1,'success',['price'=>$ProxyCode->price,'name'=>$goods->name,"remark"=>$goods->remark,"content"=>$goods->content]);
        }
    }
    
  }

  // 代理编辑
  public function proxyedit()
  {
      $goods_id = input('id/d', 0);
      $goods = GoodsModel::get(['id' => $goods_id, 'user_id' => $this->user->id]);
      if (!$goods) {
          $this->error('不存在该商品！');
      }
      if (!$this->request->isPost()) {
          $this->setTitle('添加商品');
          // 商品分类
          $categorys = CategoryModel::where(['user_id' => $this->user->id, 'status' => 1])->order('sort desc,id desc')->select();
          $this->assign('categorys', $categorys);

          $proxycode=ProxyCodeModel::get(['id' => $goods->code_id,'delect_at'=>['=',0]])->code;
          $this->assign('proxycode', $proxycode);
          $this->assign('goods', $goods);
          return $this->fetch('proxyedit');
      }

      if (input('price/f', 0) < input('cost_price/f', 0)) {
          $this->error('商品价格不能比进价低');
      }
     
      $id=input('id/s', '');
      $ngoods=ProxyCodeModel::get(['id'=>GoodsModel::get($id)->code_id,'delect_at'=>['=',0]]); //获取被代理的商品
      // 检查商品价格不能低于被代理商品
      if(input('price/f', 0)<=$ngoods->price){
        $this->error('商品价格不能低于或等于商品代理价格');
      }
      $data = [
          'user_id' => $this->user->id,
          'cate_id' => input('cate_id/d', 0),
          'theme' => input('theme/s', 'default'),
          'sort' => input('sort/d', 0),
          'name' => input('name/s', ''),
          'price' => input('price/f', 0),
          'cost_price' => $ngoods->price,
          'wholesale_discount' => input('wholesale_discount/d', 0),
          'wholesale_discount_list' => input('wholesale_discount_list/a', []),
          'limit_quantity' => input('limit_quantity/d', 1),
          'inventory_notify' => input('inventory_notify/d', 0),
          'inventory_notify_type' => input('inventory_notify_type/d', 1),
          'coupon_type' => input('coupon_type/d', 0),
          'sold_notify' => input('sold_notify/d', 0),
          'take_card_type' => input('take_card_type/d', 0),
          'visit_type' => input('visit_type/d', 0),
          'visit_password' => input('visit_password/s', ''),
          'contact_limit' => input('contact_limit/s', ''),
          'content' => input('content/s', ''),
          'remark' => input('remark/s', ''),
          'sms_payer' => input('sms_payer/d', 0),
      ];


      if ($goods->is_freeze == 1) {
          $data['is_freeze'] = 0;
      }
      // 字词检查
      $res = check_wordfilter($data['name']);
      if ($res !== true) {
          $this->error('商品名包含敏感词汇“' . $res . '”！');
      }
      $res = check_wordfilter($data['content']);
      if ($res !== true) {
          $this->error('商品说明包含敏感词汇“' . $res . '”！');
      }
      $res = check_wordfilter($data['remark']);
      if ($res !== true) {
          $this->error('使用说明包含敏感词汇“' . $res . '”！');
      }
      //检查商品价格区间
      if (sysconf('goods_min_price') > 0 && $data['price'] < sysconf('goods_min_price')) {
          $this->error('商品价格不能少于' . sysconf('goods_min_price') . '元');
      }

      if (sysconf('goods_max_price') > 0 && sysconf('goods_max_price') < $data['price']) {
          $this->error('商品价格不能超过' . sysconf('goods_max_price') . '元');
      }
      $category = CategoryModel::get(['id' => $data['cate_id'], 'user_id' => $this->user->id]);
      if (!$category) {
          $this->error('不存在该分类！');
      }
      $res = $this->validate($data, 'Goods');
      if ($res !== true) {
          $this->error($res);
      }
      $res = GoodsModel::update($data, ['id' => $goods->id]);
      if ($res !== false) {
          MerchantLogService::write('编辑商品成功', '编辑商品成功，商品ID:' . $goods_id);
          $this->redirect('/merchant/goods/proxy');
      } else {
          $this->error('保存失败！');
      }
  }


    // 删除商品
    public function del()
    {
        $goods_id = input('id/d', 0);
        $goods = GoodsModel::get(['id' => $goods_id, 'user_id' => $this->user->id]);
        if($goods->is_proxy==1){
            $res = $goods->delete();
            if ($res !== false) {
                MerchantLogService::write('删除商品', '删除ID为' . $goods_id . '的商品');
                return J(0, '删除成功！');
            } else {
                return J(1, '删除失败！');
            }
        }
        if (!$goods) {
            return J(1, '不存在该商品！');
        }
        if ($goods->cards_stock_count > 0) {
            return J(1, '该商品下存在虚拟卡，暂不能删除！');
        }
        Db::startTrans();
        try{
            $codes=ProxyCodeModel::where(['goods_id'=>$goods_id,'delect_at'=>0])->column('id');
            if(empty($codes)){
                $res = $goods->delete();
            }else{
                ProxyCodeModel::where(['goods_id'=>$goods->id])->update(['delect_at'=>time()]);
                GoodsModel::where(['code_id'=>['in',$codes]])->update(['status'=>0]);
                $res = $goods->delete();
            }
            MerchantLogService::write('修改代理商品状态', '将代理商品ID为' . $goods->id . '的商品下架');
            Db::commit();
            if ($res !== false) {
                MerchantLogService::write('删除商品', '删除ID为' . $goods_id . '的商品');
                return J(0, '删除成功！');
            } else {
                return J(1, '删除失败！');
            }
        }catch (\Exception $e) {
            Db::rollback();
            return J(1, $e->getMessage());
        }
       
        
    }

    //批量删除
    public function batch_del()
    {
        $good_ids = input('');
        $good_ids = isset($good_ids['ids']) ? $good_ids['ids'] : [];
        if (empty($good_ids)) {
            return J(1, '删除失败！');
        }
        $goods = GoodsModel::all(['id' => ['in', $good_ids], 'user_id' => $this->user->id]);
        if (!$goods) {
            return J(1, '不存在该卡！');
        }
        Db::startTrans();
        try {
            foreach ($goods as $key => $good) {
                $res = $good->delete();
                if ($res !== false) {
                    MerchantLogService::write('成功删除卡密', '成功删除卡密，ID:' . $good->id);
                } else {
                    throw new \Exception('批量删除失败，ID:' . $good->id);
                }
            }
            Db::commit();
            return J(0, '删除成功！');
        } catch (\Exception $e) {
            Db::rollback();
            return J(1, $e->getMessage());
        }
    }

    /**
     * 商品回收站
     * @return mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function trash()
    {
        $this->setTitle('商品回收站');
        ////////////////// 查询条件 //////////////////
        $query = [
            'cate_id' => input('cate_id/s', ''),
            'name' => input('name/s', ''),
        ];
        $where = $this->genereate_where($query);

        $goodsList = GoodsModel::onlyTrashed()->where($where)->order('sort desc,id desc')->paginate(30, false, [
            'query' => $query,
        ]);
        // 分页
        $page = $goodsList->render();
        $this->assign('page', $page);
        $this->assign('goodsList', $goodsList);

        // 商品分类
        $categorys = CategoryModel::where(['user_id' => $this->user->id])->order('sort desc,id desc')->select();
        $this->assign('categorys', $categorys);
        return $this->fetch();
    }

    /**
     * 恢复商品
     */
    public function restore()
    {
        $goods_id = input('id/d', 0);
        $goods = GoodsModel::onlyTrashed()->where(['id' => $goods_id, 'user_id' => $this->user->id])->find();
        if (!$goods) {
            return J(1, '不存在该商品！');
        }
        $res = GoodsModel::update(['delete_at' => null], ['id' => $goods_id, 'user_id' => $this->user->id], 'delete_at');
        if ($res !== false) {
            MerchantLogService::write('恢复商品', '恢复ID为' . $goods_id . '的商品');
            return J(0, '恢复成功！');
        } else {
            return J(1, '恢复失败！');
        }
    }

    public function restoreDelect(){
        Db::startTrans();
        try {
            $res = GoodsModel::onlyTrashed()->where(['user_id' => $this->user->id])->delete();
           
            if ($res !== false) {
                MerchantLogService::write('删除商品', '清空回收站的商品');
            } else {
                throw new \Exception('清空商品失败');
            }
            Db::commit();
            return J(0, '清空商品成功');
        } catch (\Exception $e) {
            Db::rollback();
            return J(1, $e->getMessage());
        }
    }

    /**
     * 恢复商品
     */
    public function batch_restore()
    {
        $good_ids = input('');
        $good_ids = isset($good_ids['ids']) ? $good_ids['ids'] : [];
        if (empty($good_ids)) {
            return J(1, '恢复失败！');
        }
        $goods = GoodsModel::onlyTrashed()->where(['id' => ['in', $good_ids], 'user_id' => $this->user->id])->select();
        if (!$goods) {
            return J(1, '不存在该卡！');
        }
        Db::startTrans();
        try {
            foreach ($good_ids as $id) {
                $res = GoodsModel::update(['delete_at' => null], ['id' => $id, 'user_id' => $this->user->id], 'delete_at');
                if ($res !== false) {
                    MerchantLogService::write('恢复商品', '恢复ID为' . $id . '的商品');
                } else {
                    throw new \Exception('批量恢复失败，ID:' . $id);
                }
            }
            Db::commit();
            return J(0, '恢复成功！');
        } catch (\Exception $e) {
            Db::rollback();
            return J(1, $e->getMessage());
        }
    }

    // 清空商品下所有未售的虚拟卡
    public function emptiedCards()
    {
        $goods_id = input('id/d', 0);
        $res = CardModel::update([
            'delete_at' => $_SERVER['REQUEST_TIME'],
        ], [
            'goods_id' => $goods_id,
            'user_id' => $this->user->id,
            'status' => 1,
        ]);
        if ($res !== false) {
            MerchantLogService::write('清空商品未售虚拟卡', '清空ID为' . $goods_id . '的商品未售的虚拟卡');
            return J(0, '清空成功！');
        } else {
            return J(1, '清空失败！');
        }
    }

    // 导出商品库存卡密
    public function dumpCards()
    {
        $goods_id = input('goods_id/d', 0);
        $status = input('status/d', 1);
        if ($status == 1) {
            $statusStr = '未售出';
        } elseif ($status == 2) {
            $statusStr = '已售出';
        } else {
            $this->error('未知导出状态！');
        }
        $goods = GoodsModel::get(['id' => $goods_id, 'user_id' => $this->user->id]);
        if (!$goods) {
            $this->error('不存在该商品！');
        }
        $number = input('number/d', 0);
        if ($number) {
            $cards = CardModel::limit($number)->where([
                'goods_id' => $goods_id,
                'user_id' => $this->user->id,
                'status' => $status,
                'delete_at' => null,
            ])->select();
        } else {
            $cards = CardModel::all([
                'goods_id' => $goods_id,
                'user_id' => $this->user->id,
                'status' => $status,
                'delete_at' => null,
            ]);
        }
        $fileType = input('file_type/d', 0);
        $title = ['序号', '卡号', '卡密', '状态', '添加时间'];
        $data = [];
        try {
            Db::startTrans();
            $del = input('del/d', 0);

            foreach ($cards as $k => $card) {
                $data[] = [
                    $k + 1,
                    $card->number,
                    $card->secret,
                    $statusStr,
                    date('Y-m-d H:i:s', $card->create_at),
                ];
                if ($del) {
                    $card->delete();
                }
            }
            $filename = "{$goods->name}的虚拟卡_" . date('Ymd');

            MerchantLogService::write('导出商品库存卡密', '导出ID为' . $goods_id . '的商品库存' . $statusStr . '卡密');

            Db::commit();
            if ($fileType == 0) {
                // csv 格式
                generate_excel($title, $data, $filename, $goods->name);
            } else {
                // text 文本形式
                generate_txt($title, $data, $filename, $goods->name);
            }
        } catch (Exception $e) {
            Db::rollback();
            $this->error('导出失败');
        }
    }

    /**
     * 生成查询条件
     */
    protected function genereate_where($params)
    {
        $where = [];
        $where['user_id'] = $this->user->id;
        $action = $this->request->action();
        switch ($action) {
            case 'index':
                if ($params['cate_id'] !== '') {
                    $where['cate_id'] = ['=', $params['cate_id']];
                }
                if ($params['name'] !== '') {
                    $where['name'] = ['like', '%' . $params['name'] . '%'];
                }
                $where['is_proxy']=['=', $params['is_proxy']];
            case 'trash':
                if ($params['cate_id'] !== '') {
                    $where['cate_id'] = ['=', $params['cate_id']];
                }
                if ($params['name'] !== '') {
                    $where['name'] = ['like', '%' . $params['name'] . '%'];
                }
                
                break;
            case 'proxy':
                if ($params['cate_id'] !== '') {
                    $where['cate_id'] = ['=', $params['cate_id']];
                }
                if ($params['is_proxy'] !== '') {
                    $where['is_proxy'] = ['=', $params['is_proxy']];
                }
                if ($params['name'] !== '') {
                    $where['name'] = ['like', '%' . $params['name'] . '%'];
                }
                break;   
        }
        return $where;
    }

    // 添加
    public function add()
    {
        if (!$this->request->isPost()) {
            $this->setTitle('添加商品');
            // 商品分类
            $categorys = CategoryModel::where(['user_id' => $this->user->id, 'status' => 1])->order('sort desc,id desc')->select();
            $this->assign('categorys', $categorys);
            return $this->fetch('edit');
        }

        if (input('price/f', 0) < input('cost_price/f', 0)) {
            $this->error('商品价格不能比进价低');
        }

        $data = [
            'user_id' => $this->user->id,
            'cate_id' => input('cate_id/d', 0),
            'theme' => input('theme/s', 'default'),
            'sort' => input('sort/d', 0),
            'carmisort' => input('carmisort/d', 0),
            'name' => input('name/s', ''),
            'price' => input('price/f', 0),
            'cost_price' => input('cost_price/f', 0),
            'wholesale_discount' => input('wholesale_discount/d', 0),
            'wholesale_discount_list' => input('wholesale_discount_list/a', []),
            'limit_quantity' => input('limit_quantity/d', 1),
            'inventory_notify' => input('inventory_notify/d', 0),
            'inventory_notify_type' => input('inventory_notify_type/d', 1),
            'coupon_type' => input('coupon_type/d', 0),
            'sold_notify' => input('sold_notify/d', 0),
            'take_card_type' => input('take_card_type/d', 0),
            'visit_type' => input('visit_type/d', 0),
            'visit_password' => input('visit_password/s', ''),
            'contact_limit' => input('contact_limit/s', ''),
            'content' => input('content/s', ''),
            'remark' => input('remark/s', ''),
            'sms_payer' => input('sms_payer/d', 0),
            'status' => 1,
            'create_at' => $_SERVER['REQUEST_TIME'],
        ];
        // 字词检查
        $res = check_wordfilter($data['name']);
        if ($res !== true) {
            $this->error('商品名包含敏感词汇“' . $res . '”！');
        }
        $res = check_wordfilter($data['content']);
        if ($res !== true) {
            $this->error('商品说明包含敏感词汇“' . $res . '”！');
        }
        $res = check_wordfilter($data['remark']);
        if ($res !== true) {
            $this->error('使用说明包含敏感词汇“' . $res . '”！');
        }
        $category = CategoryModel::get(['id' => $data['cate_id'], 'user_id' => $this->user->id]);
        if (!$category) {
            $this->error('不存在该分类！');
        }
        //检查商品价格区间
        if (sysconf('goods_min_price') > 0 && $data['price'] < sysconf('goods_min_price')) {
            $this->error('商品价格不能少于' . sysconf('goods_min_price') . '元');
        }

        if (sysconf('goods_max_price') > 0 && sysconf('goods_max_price') < $data['price']) {
            $this->error('商品价格不能超过' . sysconf('goods_max_price') . '元');
        }

        $res = $this->validate($data, 'Goods');
        if ($res !== true) {
            $this->error($res);
        }
        $res = GoodsModel::create($data);
        if ($res !== false) {
            //创建成功，马上创建短链接
            GoodsModel::makeLink($data['user_id'], $res->id);
            MerchantLogService::write('添加商品成功', '添加商品成功，商品ID:' . $res->id . ',名称:' . $res->name . ',价格:' . $res->price . ',成本价:' . $res->cost_price);
            $this->redirect('/merchant/goods/index');
        } else {
            $this->error('添加失败！');
        }
    }

    // 编辑
    public function edit()
    {
        $goods_id = input('id/d', 0);
        $goods = GoodsModel::get(['id' => $goods_id, 'user_id' => $this->user->id]);

        if (!$goods) {
            $this->error('不存在该商品！');
        }

        if (!$this->request->isPost()) {
            $this->setTitle('添加商品');
            // 商品分类
            $categorys = CategoryModel::where(['user_id' => $this->user->id, 'status' => 1])->order('sort desc,id desc')->select();

            $this->assign('categorys', $categorys);
            $this->assign('goods', $goods);
     
            return $this->fetch('edit');
        }

        if (input('price/f', 0) < input('cost_price/f', 0)) {
            $this->error('商品价格不能比进价低');
        }

        $data = [
            'user_id' => $this->user->id,
            'cate_id' => input('cate_id/d', 0),
            'theme' => input('theme/s', 'default'),
            'sort' => input('sort/d', 0),
            'carmisort' => input('carmisort/d', 0),
            'name' => input('name/s', ''),
            'price' => input('price/f', 0),
            'cost_price' => input('cost_price/f', 0),
            'wholesale_discount' => input('wholesale_discount/d', 0),
            'wholesale_discount_list' => input('wholesale_discount_list/a', []),
            'limit_quantity' => input('limit_quantity/d', 1),
            'inventory_notify' => input('inventory_notify/d', 0),
            'inventory_notify_type' => input('inventory_notify_type/d', 1),
            'coupon_type' => input('coupon_type/d', 0),
            'sold_notify' => input('sold_notify/d', 0),
            'take_card_type' => input('take_card_type/d', 0),
            'visit_type' => input('visit_type/d', 0),
            'visit_password' => input('visit_password/s', ''),
            'contact_limit' => input('contact_limit/s', ''),
            'content' => input('content/s', ''),
            'remark' => input('remark/s', ''),
            'sms_payer' => input('sms_payer/d', 0),
        ];
        if ($goods->is_freeze == 1) {
            $data['is_freeze'] = 0;
        }
        // 字词检查
        $res = check_wordfilter($data['name']);
        if ($res !== true) {
            $this->error('商品名包含敏感词汇“' . $res . '”！');
        }
        $res = check_wordfilter($data['content']);
        if ($res !== true) {
            $this->error('商品说明包含敏感词汇“' . $res . '”！');
        }
        $res = check_wordfilter($data['remark']);
        if ($res !== true) {
            $this->error('使用说明包含敏感词汇“' . $res . '”！');
        }
        //检查商品价格区间
        if (sysconf('goods_min_price') > 0 && $data['price'] < sysconf('goods_min_price')) {
            $this->error('商品价格不能少于' . sysconf('goods_min_price') . '元');
        }

        if (sysconf('goods_max_price') > 0 && sysconf('goods_max_price') < $data['price']) {
            $this->error('商品价格不能超过' . sysconf('goods_max_price') . '元');
        }
        $category = CategoryModel::get(['id' => $data['cate_id'], 'user_id' => $this->user->id]);
        if (!$category) {
            $this->error('不存在该分类！');
        }
        $res = $this->validate($data, 'Goods');
        if ($res !== true) {
            $this->error($res);
        }
        $res = GoodsModel::update($data, ['id' => $goods->id]);
        if ($res !== false) {
            MerchantLogService::write('编辑商品成功', '编辑商品成功，商品ID:' . $goods_id);
            $this->redirect('/merchant/goods/index');
        } else {
            $this->error('保存失败！');
        }
    }

    // 商品购买链接
    public function link()
    {
        $goods_id = input('id/d', 0);
        $goods = GoodsModel::get(['id' => $goods_id, 'user_id' => $this->user->id]);
        if (!$goods) {
            return J(1, '不存在该商品！');
        }
        $this->setTitle('购买链接');
        $this->assign('goods', $goods);
        $this->assign('short_link', $goods->shortLink);
        return $this->fetch();
    }
}
